/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    private static final String propertyPrefix = "CheckBox.";
    private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceCheckBoxUI");

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceCheckBoxUI((JToggleButton)comp);
    }

    public SubstanceCheckBoxUI(JToggleButton button) {
        super(button);
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.button.setRolloverEnabled(true);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(SubstanceSizeUtils.getCheckBoxBorder(SubstanceSizeUtils.getComponentFontSize(b)));
        }
    }

    private static Icon getIcon(JToggleButton button, ComponentState currState, ComponentState prevState) {
        float checkMarkVisibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        boolean isCheckMarkFadingOut = false;
        SubstanceColorScheme currFillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.FILL, currState);
        SubstanceColorScheme prevFillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.FILL, prevState);
        SubstanceColorScheme currMarkColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.MARK, currState);
        SubstanceColorScheme prevMarkColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.MARK, prevState);
        SubstanceColorScheme currBorderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.BORDER, currState);
        SubstanceColorScheme prevBorderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.BORDER, prevState);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                checkMarkVisibility = fadeState.getFadePosition();
                isCheckMarkFadingOut = !fadeState.isFadingIn();
            }
        }
        int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
        int checkMarkSize = SubstanceSizeUtils.getCheckBoxMarkSize(fontSize);
        SubstanceGradientPainter fillPainter = SubstanceCoreUtilities.getGradientPainter(button);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(button);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(fontSize, checkMarkSize, currState.name(), prevState.name(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), currFillColorScheme.getDisplayName(), prevFillColorScheme.getDisplayName(), currMarkColorScheme.getDisplayName(), prevMarkColorScheme.getDisplayName(), currBorderColorScheme.getDisplayName(), prevBorderColorScheme.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(checkMarkVisibility), isCheckMarkFadingOut);
        Icon result = icons.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getCheckBox(button, fillPainter, borderPainter, checkMarkSize, currState, prevState, currFillColorScheme, prevFillColorScheme, currMarkColorScheme, prevMarkColorScheme, currBorderColorScheme, prevBorderColorScheme, cyclePos, checkMarkVisibility, isCheckMarkFadingOut));
        icons.put(key, result);
        return result;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    @Override
    public Icon getDefaultIcon() {
        ComponentState currState = ComponentState.getState(this.button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.button);
        return SubstanceCheckBoxUI.getIcon(this.button, currState, prevState);
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceCheckBox: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }
}

