/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceFileChooserUI
extends MetalFileChooserUI {
    private final SubstanceFileView fileView = new SubstanceFileView();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceFileChooserUI((JFileChooser)comp);
    }

    public SubstanceFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    private class SubstanceFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private SubstanceFileView() {
            super(SubstanceFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        @Override
        public Icon getCachedIcon(File f) {
            return this.pathIconCache.get(f.getPath());
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = this.getDefaultIcon(f);
            if (icon == null && (icon = super.getIcon(f)) == null) {
                icon = new ImageIcon(SubstanceCoreUtilities.getBlankImage(8, 8));
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        @Override
        public void cacheIcon(File f, Icon icon) {
            this.pathIconCache.put(f.getPath(), icon);
        }

        @Override
        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File f) {
            JFileChooser fileChooser = SubstanceFileChooserUI.this.getFileChooser();
            Icon icon = fileChooser.getFileSystemView().getSystemIcon(f);
            if (SubstanceCoreUtilities.useThemedDefaultIcon()) {
                icon = SubstanceCoreUtilities.getThemedIcon(fileChooser, icon);
            }
            return icon;
        }
    }
}

