/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.animation.UIThreadFadeTrackerAdapter;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTableHeaderUI;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.painter.utils.HighlightPainterUtils;
import org.jvnet.substance.utils.SubstanceColorResource;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceStripingUtils;

public class SubstanceTableUI
extends BasicTableUI {
    protected Map<TableCellId, Object> selectedIndices = new HashMap<TableCellId, Object>();
    protected TableId rolledOverId;
    protected int focusedRow = -1;
    protected int focusedColumn = -1;
    protected int rolledOverColumn = -1;
    protected Map<Class<?>, TableCellRenderer> defaultRenderers;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected TableStateListener substanceFadeSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    private Map<TableCellId, ComponentState> prevStateMap = new HashMap<TableCellId, ComponentState>();
    private Map<TableCellId, ComponentState> nextStateMap = new HashMap<TableCellId, ComponentState>();
    private Insets cellRendererInsets;
    TableRowId rowId = new TableRowId(-1);
    TableColumnId colId = new TableColumnId(-1);
    TableCellId cellId = new TableCellId(-1, -1);
    private UpdateOptimizationInfo updateInfo;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceTableUI();
    }

    @Override
    protected void installDefaults() {
        Class[] defClasses;
        super.installDefaults();
        if (SubstanceCoreUtilities.toDrawWatermark(this.table)) {
            this.table.setOpaque(false);
        }
        this.defaultRenderers = new HashMap();
        for (Class clazz : defClasses = new Class[]{Object.class, Icon.class, ImageIcon.class, Number.class, Float.class, Double.class, Date.class, Boolean.class}) {
            this.defaultRenderers.put(clazz, this.table.getDefaultRenderer(clazz));
        }
        this.installRendererIfNecessary(Object.class, new SubstanceDefaultTableCellRenderer());
        this.installRendererIfNecessary(Icon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(ImageIcon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(Number.class, new SubstanceDefaultTableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Float.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Double.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Date.class, new SubstanceDefaultTableCellRenderer.DateRenderer());
        this.installRendererIfNecessary(Boolean.class, new SubstanceDefaultTableCellRenderer.BooleanRenderer());
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!this.table.isCellSelected(i, j)) continue;
                TableCellId cellId = new TableCellId(i, j);
                this.selectedIndices.put(cellId, this.table.getValueAt(i, j));
                this.prevStateMap.put(cellId, ComponentState.SELECTED);
            }
        }
        boolean areAllRenderersFromSubstance = true;
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            TableCellRenderer renderer = column.getCellRenderer();
            if (renderer == null) {
                renderer = this.table.getDefaultRenderer(this.table.getColumnClass(i));
            }
            if (renderer instanceof SubstanceDefaultTableCellRenderer || renderer instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer) continue;
            areAllRenderersFromSubstance = false;
            break;
        }
        if (areAllRenderersFromSubstance) {
            Insets rendererInsets = SubstanceSizeUtils.getTableCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(this.table));
            JLabel dummy = new JLabel("dummy");
            dummy.setFont(this.table.getFont());
            int rowHeight = dummy.getPreferredSize().height + rendererInsets.bottom + rendererInsets.top;
            this.table.setRowHeight(rowHeight);
        }
        this.table.putClientProperty("substancelaf.internal.highlightUse", Boolean.TRUE);
        this.cellRendererInsets = SubstanceSizeUtils.getTableCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(this.table));
    }

    protected void installRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isCore;
            boolean bl = isCore = currRenderer instanceof DefaultTableCellRenderer.UIResource || currRenderer.getClass().getName().startsWith("javax.swing.JTable");
            if (!isCore) {
                return;
            }
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    @Override
    protected void uninstallDefaults() {
        for (Map.Entry<Class<?>, TableCellRenderer> entry : this.defaultRenderers.entrySet()) {
            this.uninstallRendererIfNecessary(entry.getKey(), entry.getValue());
        }
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    protected void uninstallRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        boolean isSubstanceRenderer;
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null && !(isSubstanceRenderer = this.isSubstanceDefaultRenderer(currRenderer))) {
            return;
        }
        if (renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JTableHeader header;
                Object old;
                if ("substancelaf.watermark.visible".equals(evt.getPropertyName())) {
                    SubstanceTableUI.this.table.setOpaque(!SubstanceCoreUtilities.toDrawWatermark(SubstanceTableUI.this.table));
                }
                if ("columnSelectionAllowed".equals(evt.getPropertyName()) || "rowSelectionAllowed".equals(evt.getPropertyName())) {
                    SubstanceTableUI.this.syncSelection();
                }
                if ("model".equals(evt.getPropertyName())) {
                    old = (TableModel)evt.getOldValue();
                    if (old != null) {
                        old.removeTableModelListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    }
                    SubstanceTableUI.this.table.getModel().addTableModelListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.prevStateMap.clear();
                    SubstanceTableUI.this.nextStateMap.clear();
                    SubstanceTableUI.this.syncSelection();
                }
                if ("columnModel".equals(evt.getPropertyName())) {
                    old = (TableColumnModel)evt.getOldValue();
                    if (old != null) {
                        old.getSelectionModel().removeListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    }
                    SubstanceTableUI.this.table.getColumnModel().getSelectionModel().addListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.prevStateMap.clear();
                    SubstanceTableUI.this.nextStateMap.clear();
                    SubstanceTableUI.this.syncSelection();
                    JTableHeader tableHeader = SubstanceTableUI.this.table.getTableHeader();
                    if (tableHeader != null) {
                        SubstanceTableHeaderUI headerUI = (SubstanceTableHeaderUI)tableHeader.getUI();
                        headerUI.processColumnModelChangeEvent((TableColumnModel)evt.getOldValue(), (TableColumnModel)evt.getNewValue());
                    }
                }
                if ("selectionModel".equals(evt.getPropertyName())) {
                    old = (ListSelectionModel)evt.getOldValue();
                    if (old != null) {
                        old.removeListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    }
                    SubstanceTableUI.this.table.getSelectionModel().addListSelectionListener(SubstanceTableUI.this.substanceFadeSelectionListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.prevStateMap.clear();
                    SubstanceTableUI.this.nextStateMap.clear();
                    SubstanceTableUI.this.syncSelection();
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceTableUI.this.table == null) {
                                return;
                            }
                            SubstanceTableUI.this.table.updateUI();
                        }
                    });
                }
                if ("background".equals(evt.getPropertyName())) {
                    Color headerBackground;
                    Color newBackgr = (Color)evt.getNewValue();
                    JTableHeader header2 = SubstanceTableUI.this.table.getTableHeader();
                    if (header2 != null && SubstanceCoreUtilities.canReplaceChildBackgroundColor(headerBackground = header2.getBackground())) {
                        if (!(newBackgr instanceof UIResource)) {
                            header2.setBackground(new SubstanceColorResource(newBackgr));
                        } else {
                            header2.setBackground(newBackgr);
                        }
                    }
                }
                if ("enabled".equals(evt.getPropertyName()) && (header = SubstanceTableUI.this.table.getTableHeader()) != null) {
                    header.setEnabled(SubstanceTableUI.this.table.isEnabled());
                }
            }
        };
        this.table.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceFadeSelectionListener = new TableStateListener();
        this.table.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        this.table.getModel().addTableModelListener(this.substanceFadeSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.table.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.addMouseListener(this.substanceFadeRolloverListener);
    }

    @Override
    protected void uninstallListeners() {
        this.table.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.table.getColumnModel().getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.table.getModel().removeTableModelListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.table.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            return;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintDropLines(g);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        Graphics2D g2d = (Graphics2D)g.create();
        ComponentState currState = this.table.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.table, currState);
        g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, alpha, g));
        Color gridColor = this.table.getGridColor();
        if (gridColor instanceof UIResource) {
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.table, ColorSchemeAssociationKind.BORDER, this.table.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
            gridColor = scheme.getLineColor();
        }
        g2d.setColor(gridColor);
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table));
        g2d.setStroke(new BasicStroke(strokeWidth, 1, 2));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = rMin; row <= rMax; ++row) {
                g2d.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int x;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    x += w;
                    if (column == cm.getColumnCount() - 1) continue;
                    g2d.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column <= cMax; ++column) {
                    g2d.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                    int w = cm.getColumn(column).getWidth();
                    x -= w;
                }
                g2d.drawLine(x, 0, x, tableHeight - 1);
            }
        }
        g2d.dispose();
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        int row;
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        int rowMargin = this.table.getRowMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                Rectangle highlightCellRect = new Rectangle(cellRect);
                highlightCellRect.y -= rowMargin / 2;
                highlightCellRect.height += rowMargin;
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    highlightCellRect.x = cellRect.x - columnMargin / 2;
                    highlightCellRect.width = columnWidth;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, highlightCellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                Rectangle highlightCellRect = new Rectangle(cellRect);
                highlightCellRect.y -= rowMargin / 2;
                highlightCellRect.height += rowMargin;
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    highlightCellRect.x = cellRect.x - columnMargin / 2;
                    highlightCellRect.width = columnWidth;
                    this.paintCell(g, cellRect, highlightCellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    highlightCellRect.x = cellRect.x - columnMargin / 2;
                    highlightCellRect.width = columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, highlightCellRect, row, column);
                }
            }
        }
        if (draggedColumn != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, 0.65f, g));
            this.paintDraggedArea(g2d, rMin, rMax, draggedColumn, header.getDraggedDistance());
            g2d.dispose();
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    protected void paintCell(Graphics g, Rectangle cellRect, Rectangle highlightCellRect, int row, int column) {
        boolean isRollover;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
        TableCellId cellId = new TableCellId(row, column);
        ComponentState prevState = this.getPrevCellState(cellId);
        ComponentState currState = this.getCellState(cellId);
        FadeState state = this.updateInfo.hasRolloverAnimations || this.updateInfo.hasSelectionAnimations ? SubstanceFadeUtilities.getFadeState((Component)this.table, cellId, FadeKind.SELECTION, FadeKind.ROLLOVER) : null;
        boolean hasHighlights = prevState != ComponentState.DEFAULT || currState != ComponentState.DEFAULT || state != null;
        EnumSet<SubstanceConstants.Side> highlightOpenSides = null;
        float highlightBorderAlpha = 0.0f;
        float totalHighlightAlpha = 0.0f;
        SubstanceColorScheme prevHighlightScheme = null;
        SubstanceColorScheme currHighlightScheme = null;
        SubstanceColorScheme prevBorderScheme = null;
        SubstanceColorScheme currBorderScheme = null;
        float fadeHighlightCoef = 0.0f;
        if (hasHighlights) {
            ComponentState leftNeighbourState;
            ComponentState upperNeighbourState;
            float endHighlightAlpha;
            prevHighlightScheme = this.updateInfo.getHighlightColorScheme(prevState);
            currHighlightScheme = this.updateInfo.getHighlightColorScheme(currState);
            prevBorderScheme = this.updateInfo.getHighlightBorderColorScheme(prevState);
            currBorderScheme = this.updateInfo.getHighlightBorderColorScheme(currState);
            float startHighlightAlpha = this.updateInfo.getHighlightAlpha(prevState);
            totalHighlightAlpha = endHighlightAlpha = this.updateInfo.getHighlightAlpha(currState);
            if (state != null) {
                fadeHighlightCoef = state.getFadePosition();
                totalHighlightAlpha = state.isFadingIn() ? startHighlightAlpha + (endHighlightAlpha - startHighlightAlpha) * fadeHighlightCoef : startHighlightAlpha + (endHighlightAlpha - startHighlightAlpha) * (1.0f - fadeHighlightCoef);
                if (state.isFadingIn()) {
                    fadeHighlightCoef = 1.0f - fadeHighlightCoef;
                }
            }
            if (!this.updateInfo.hasSelectionAnimations && (prevState.isKindActive(FadeKind.SELECTION) || currState.isKindActive(FadeKind.SELECTION))) {
                fadeHighlightCoef = 0.0f;
            }
            highlightOpenSides = EnumSet.noneOf(SubstanceConstants.Side.class);
            float f = highlightBorderAlpha = this.table.getShowHorizontalLines() || this.table.getShowVerticalLines() ? 0.0f : 0.8f;
            if (!this.table.getColumnSelectionAllowed() && this.table.getRowSelectionAllowed()) {
                highlightOpenSides.add(SubstanceConstants.Side.LEFT);
                highlightOpenSides.add(SubstanceConstants.Side.RIGHT);
            }
            if (this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed()) {
                highlightOpenSides.add(SubstanceConstants.Side.TOP);
                highlightOpenSides.add(SubstanceConstants.Side.BOTTOM);
            }
            if (row > 1 && currState == (upperNeighbourState = this.getCellState(new TableCellId(row - 1, column)))) {
                highlightOpenSides.add(SubstanceConstants.Side.TOP);
            }
            if (column > 1 && currState == (leftNeighbourState = this.getCellState(new TableCellId(row, column - 1)))) {
                highlightOpenSides.add(SubstanceConstants.Side.LEFT);
            }
            if (row == 0) {
                highlightOpenSides.add(SubstanceConstants.Side.TOP);
            }
            if (row == this.table.getRowCount() - 1) {
                highlightOpenSides.add(SubstanceConstants.Side.BOTTOM);
            }
            if (column == 0) {
                highlightOpenSides.add(SubstanceConstants.Side.LEFT);
            }
            if (column == this.table.getColumnCount() - 1) {
                highlightOpenSides.add(SubstanceConstants.Side.RIGHT);
            }
        }
        boolean bl = isRollover = this.rolledOverId != null && this.rolledOverId.equals(cellId);
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            if (totalHighlightAlpha > 0.0f) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, totalHighlightAlpha, g));
                HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, component, highlightCellRect, highlightBorderAlpha, highlightOpenSides, currHighlightScheme, prevHighlightScheme, currBorderScheme, prevBorderScheme, fadeHighlightCoef);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (component instanceof JComponent) {
                boolean newOpaque;
                boolean bl2 = newOpaque = !this.selectedIndices.containsKey(cellId) && !isRollover && state == null;
                if (this.updateInfo.toDrawWatermark) {
                    newOpaque = false;
                }
                this.updateInfo.opacity.clear();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(component, this.updateInfo.opacity);
                }
                component.setBounds(cellRect);
                component.validate();
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(component, this.updateInfo.opacity);
                }
            } else {
                component.setBounds(cellRect);
                component.validate();
            }
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            boolean isSubstanceRenderer = this.isSubstanceDefaultRenderer(renderer);
            Component rendererComponent = this.table.prepareRenderer(renderer, row, column);
            boolean isWatermarkBleed = this.updateInfo.toDrawWatermark;
            if (rendererComponent != null) {
                if (!isWatermarkBleed) {
                    Color background = rendererComponent.getBackground();
                    if (background != null && (!this.table.getBackground().equals(background) || this.updateInfo.isInDecorationArea)) {
                        g2d.setColor(background);
                        g2d.fillRect(highlightCellRect.x, highlightCellRect.y, highlightCellRect.width, highlightCellRect.height);
                    }
                } else {
                    BackgroundPaintingUtils.fillAndWatermark(g2d, this.table, rendererComponent.getBackground(), highlightCellRect);
                }
            }
            if (isSubstanceRenderer && totalHighlightAlpha > 0.0f) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(this.table, totalHighlightAlpha, g));
                float extra = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table.getTableHeader()));
                float extraWidth = highlightOpenSides.contains((Object)SubstanceConstants.Side.LEFT) ? 0.0f : extra;
                float extraHeight = highlightOpenSides.contains((Object)SubstanceConstants.Side.TOP) ? 0.0f : extra;
                HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, new Rectangle(highlightCellRect.x - (int)extraWidth, highlightCellRect.y - (int)extraHeight, highlightCellRect.width + (int)extraWidth, highlightCellRect.height + (int)extraHeight), highlightBorderAlpha, highlightOpenSides, currHighlightScheme, prevHighlightScheme, currBorderScheme, prevBorderScheme, fadeHighlightCoef);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.table, g));
            }
            if (rendererComponent instanceof JComponent) {
                boolean newOpaque;
                JComponent jRenderer = (JComponent)rendererComponent;
                boolean isSelected = this.updateInfo.hasSelectionAnimations ? this.selectedIndices.containsKey(cellId) : this.table.isCellSelected(row, column);
                boolean bl3 = newOpaque = !isSelected && !isRollover && state == null;
                if (this.updateInfo.toDrawWatermark) {
                    newOpaque = false;
                }
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g2d, rendererComponent, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            } else {
                this.rendererPane.paintComponent(g2d, rendererComponent, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }
        }
        g2d.dispose();
    }

    private void paintDropLines(Graphics g) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color shortColor = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (ltr) {
                rect.x += rect.width;
            }
        } else if (!ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    private Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    private FadeTrackerCallback getCallback(int row, int column) {
        boolean hasRowSelection = this.table.getRowSelectionAllowed();
        boolean hasColumnSelection = this.table.getColumnSelectionAllowed();
        if (hasRowSelection && !hasColumnSelection) {
            return new RowRepaintCallback(this.table, row);
        }
        if (!hasRowSelection && hasColumnSelection) {
            return new ColumnRepaintCallback(this.table, column);
        }
        return new CellRepaintCallback(this.table, row, column);
    }

    private FadeTrackerCallback getCallback(Comparable<?> comparable) {
        if (comparable instanceof TableRowId) {
            return new RowRepaintCallback(this.table, ((TableRowId)comparable).row);
        }
        if (comparable instanceof TableColumnId) {
            return new ColumnRepaintCallback(this.table, ((TableColumnId)comparable).column);
        }
        return new CellRepaintCallback(this.table, ((TableCellId)comparable).row, ((TableCellId)comparable).column);
    }

    public TableId getId(int row, int column) {
        boolean hasRowSelection = this.table.getRowSelectionAllowed();
        boolean hasColumnSelection = this.table.getColumnSelectionAllowed();
        if (hasRowSelection && !hasColumnSelection) {
            this.rowId.row = row;
            return this.rowId;
        }
        if (!hasRowSelection && hasColumnSelection) {
            this.colId.column = column;
            return this.colId;
        }
        this.cellId.column = column;
        this.cellId.row = row;
        return this.cellId;
    }

    protected void syncSelection() {
        if (this.table == null) {
            return;
        }
        int rows = this.table.getRowCount();
        int cols = this.table.getColumnCount();
        int rowLeadIndex = this.table.getSelectionModel().getLeadSelectionIndex();
        int colLeadIndex = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        boolean isFocusOwner = this.table.isFocusOwner();
        if (!this._hasSelectionAnimations()) {
            this.prevStateMap.clear();
            this.table.repaint();
            if (isFocusOwner) {
                this.focusedRow = rowLeadIndex;
                this.focusedColumn = colLeadIndex;
            }
            return;
        }
        HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
        boolean fadeCanceled = false;
        FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                FadeTrackerCallback callback;
                boolean cellHasFocus;
                TableCellId cellId;
                if (this.table.isCellSelected(i, j)) {
                    cellId = new TableCellId(i, j);
                    if (!this.selectedIndices.containsKey(cellId)) {
                        if (!fadeCanceled) {
                            long fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)this.table, cellId, false, (FadeTrackerCallback)new CellRepaintCallback(this.table, i, j));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 15) {
                                SubstanceFadeUtilities.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        } else {
                            new CellRepaintCallback(this.table, i, j).fadeEnded(FadeKind.SELECTION);
                        }
                        this.selectedIndices.put(cellId, this.table.getValueAt(i, j));
                    }
                } else {
                    cellId = new TableCellId(i, j);
                    if (this.selectedIndices.containsKey(cellId)) {
                        Object oldValue = this.selectedIndices.get(cellId);
                        Object currValue = this.table.getValueAt(i, j);
                        boolean isSame = false;
                        isSame = oldValue == null ? currValue == null : oldValue.equals(currValue);
                        if (isSame) {
                            if (!fadeCanceled) {
                                long fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)this.table, cellId, false, (FadeTrackerCallback)new CellRepaintCallback(this.table, i, j));
                                initiatedFadeSequences.add(fadeId);
                                if (initiatedFadeSequences.size() > 15) {
                                    SubstanceFadeUtilities.cancelFades(initiatedFadeSequences);
                                    initiatedFadeSequences.clear();
                                    fadeCanceled = true;
                                }
                            } else {
                                new CellRepaintCallback(this.table, i, j).fadeEnded(FadeKind.SELECTION);
                            }
                        }
                        this.selectedIndices.remove(cellId);
                    }
                }
                boolean bl = cellHasFocus = isFocusOwner && i == rowLeadIndex && j == colLeadIndex;
                if (cellHasFocus) {
                    if (this.focusedRow == i && this.focusedColumn == j) continue;
                    if (this.focusedRow >= 0 && this.focusedColumn >= 0) {
                        TableCellId prevFocusedId = new TableCellId(this.focusedRow, this.focusedColumn);
                        prevFocusedId.setExactComparison(true);
                        callback = this.getCallback(prevFocusedId);
                        FadeTracker.getInstance().trackFadeOut(FadeKind.FOCUS, (Component)this.table, prevFocusedId, false, callback);
                    }
                    FadeTrackerCallback callback2 = this.getCallback(i, j);
                    TableCellId currId = new TableCellId(i, j);
                    currId.setExactComparison(true);
                    FadeTracker.getInstance().trackFadeIn(FadeKind.FOCUS, (Component)this.table, currId, false, callback2);
                    if (!FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.FOCUS, this.table)) continue;
                    this.focusedRow = i;
                    this.focusedColumn = j;
                    continue;
                }
                if (this.focusedRow != i || this.focusedColumn != j) continue;
                TableCellId prevFocusedId = new TableCellId(this.focusedRow, this.focusedColumn);
                prevFocusedId.setExactComparison(true);
                callback = this.getCallback(prevFocusedId);
                FadeTracker.getInstance().trackFadeOut(FadeKind.FOCUS, (Component)this.table, prevFocusedId, false, callback);
                this.focusedRow = -1;
                this.focusedColumn = -1;
            }
        }
    }

    public ComponentState getPrevCellState(TableCellId cellIndex) {
        if (this.prevStateMap.containsKey(cellIndex)) {
            return this.prevStateMap.get(cellIndex);
        }
        return this.getCellState(cellIndex);
    }

    public ComponentState getCellState(TableCellId cellIndex) {
        int row = cellIndex.row;
        int column = cellIndex.column;
        TableId cellId = this.getId(row, column);
        boolean isEnabled = this.table.isEnabled();
        boolean isRollover = cellId.equals(this.rolledOverId);
        boolean isSelected = false;
        boolean hasSelectionAnimations = this.updateInfo != null ? this.updateInfo.hasSelectionAnimations : this._hasSelectionAnimations();
        isSelected = hasSelectionAnimations && FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.SELECTION, this.table) ? this.selectedIndices.containsKey(cellId) : this.table.isCellSelected(row, column);
        return ComponentState.getState(isEnabled, isRollover, isSelected);
    }

    protected boolean _hasAnimations() {
        int colCount;
        int rowCount = this.table.getRowCount();
        if (rowCount * (colCount = this.table.getColumnCount()) >= 500) {
            return false;
        }
        if (this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed()) {
            if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                return rowCount <= 8;
            }
            return rowCount <= 25;
        }
        if (!this.table.getColumnSelectionAllowed() && this.table.getRowSelectionAllowed()) {
            if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                return colCount <= 8;
            }
            return colCount <= 25;
        }
        return true;
    }

    protected boolean _hasSelectionAnimations() {
        return this._hasAnimations() && !LafWidgetUtilities.hasNoFades(this.table, FadeKind.SELECTION);
    }

    protected boolean _hasRolloverAnimations() {
        return this._hasAnimations() && !LafWidgetUtilities.hasNoFades(this.table, FadeKind.ROLLOVER);
    }

    public int getRolloverColumnIndex() {
        return this.rolledOverColumn;
    }

    public boolean isFocusedCell(int row, int column) {
        return this.focusedRow == row && this.focusedColumn == column;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        Graphics2D g2d = (Graphics2D)g.create();
        SubstanceStripingUtils.setup(c);
        this.updateInfo = new UpdateOptimizationInfo();
        this.paint(g2d, c);
        SubstanceStripingUtils.tearDown(c);
        g2d.dispose();
        this.updateInfo = null;
    }

    public Insets getCellRendererInsets() {
        return this.cellRendererInsets;
    }

    public SubstanceColorScheme getDefaultColorScheme() {
        if (this.updateInfo != null) {
            return this.updateInfo.defaultScheme;
        }
        return null;
    }

    public SubstanceColorScheme getHighlightColorScheme(ComponentState state) {
        if (this.updateInfo != null) {
            return this.updateInfo.getHighlightColorScheme(state);
        }
        return null;
    }

    public boolean hasSelectionAnimations() {
        if (this.updateInfo != null) {
            return this.updateInfo.hasSelectionAnimations;
        }
        return this._hasSelectionAnimations();
    }

    public boolean hasRolloverAnimations() {
        if (this.updateInfo != null) {
            return this.updateInfo.hasRolloverAnimations;
        }
        return this._hasRolloverAnimations();
    }

    private boolean isSubstanceDefaultRenderer(TableCellRenderer renderer) {
        return renderer instanceof SubstanceDefaultTableCellRenderer || renderer instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer;
    }

    private class UpdateOptimizationInfo {
        public boolean toDrawWatermark;
        private Map<ComponentState, SubstanceColorScheme> highlightSchemeMap;
        private Map<ComponentState, SubstanceColorScheme> borderSchemeMap;
        private Map<ComponentState, Float> highlightAlphaMap;
        public SubstanceColorScheme defaultScheme;
        public boolean hasSelectionAnimations;
        public boolean hasRolloverAnimations;
        public Map<Component, Boolean> opacity;
        public DecorationAreaType decorationAreaType;
        public boolean isInDecorationArea;

        public UpdateOptimizationInfo() {
            this.toDrawWatermark = SubstanceCoreUtilities.toDrawWatermark(SubstanceTableUI.this.table);
            this.defaultScheme = SubstanceColorSchemeUtilities.getColorScheme(SubstanceTableUI.this.table, ComponentState.DEFAULT);
            this.highlightAlphaMap = new EnumMap<ComponentState, Float>(ComponentState.class);
            this.highlightSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
            this.borderSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
            this.hasSelectionAnimations = SubstanceTableUI.this._hasSelectionAnimations();
            this.opacity = new HashMap<Component, Boolean>();
            this.decorationAreaType = SubstanceLookAndFeel.getDecorationType(SubstanceTableUI.this.table);
            SubstanceSkin skin = SubstanceCoreUtilities.getSkin(SubstanceTableUI.this.table);
            this.isInDecorationArea = this.decorationAreaType != null && skin.isRegisteredAsDecorationArea(this.decorationAreaType) && TransitionLayout.isOpaque(SubstanceTableUI.this.table);
        }

        public SubstanceColorScheme getHighlightColorScheme(ComponentState state) {
            if (!this.highlightSchemeMap.containsKey((Object)state)) {
                this.highlightSchemeMap.put(state, SubstanceColorSchemeUtilities.getColorScheme(SubstanceTableUI.this.table, ColorSchemeAssociationKind.HIGHLIGHT, state));
            }
            return this.highlightSchemeMap.get((Object)state);
        }

        public SubstanceColorScheme getHighlightBorderColorScheme(ComponentState state) {
            if (!this.borderSchemeMap.containsKey((Object)state)) {
                this.borderSchemeMap.put(state, SubstanceColorSchemeUtilities.getColorScheme(SubstanceTableUI.this.table, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, state));
            }
            return this.borderSchemeMap.get((Object)state);
        }

        public float getHighlightAlpha(ComponentState state) {
            if (!this.highlightAlphaMap.containsKey((Object)state)) {
                this.highlightAlphaMap.put(state, Float.valueOf(SubstanceColorSchemeUtilities.getHighlightAlpha(SubstanceTableUI.this.table, state)));
            }
            return this.highlightAlphaMap.get((Object)state).floatValue();
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.fadeOut();
            this.fadeOutTableHeader();
            SubstanceTableUI.this.rolledOverId = null;
            SubstanceTableUI.this.rolledOverColumn = -1;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMove(e);
            this.handleMoveForHeader(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMove(e);
            this.handleMoveForHeader(e);
        }

        private void handleMove(MouseEvent e) {
            int row = SubstanceTableUI.this.table.rowAtPoint(e.getPoint());
            int column = SubstanceTableUI.this.table.columnAtPoint(e.getPoint());
            if (row < 0 || row >= SubstanceTableUI.this.table.getRowCount() || column < 0 || column >= SubstanceTableUI.this.table.getColumnCount()) {
                this.fadeOut();
                SubstanceTableUI.this.rolledOverId = null;
            } else {
                TableId newId = SubstanceTableUI.this.getId(row, column).cloneId();
                if (SubstanceTableUI.this.rolledOverId != null && newId.equals(SubstanceTableUI.this.rolledOverId)) {
                    return;
                }
                this.fadeOut();
                FadeTrackerCallback callback = SubstanceTableUI.this.getCallback(row, column);
                if (SubstanceTableUI.this._hasRolloverAnimations()) {
                    FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceTableUI.this.table, newId, false, callback);
                } else {
                    callback.fadeEnded(FadeKind.ROLLOVER);
                }
                if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ROLLOVER, SubstanceTableUI.this.table)) {
                    SubstanceTableUI.this.rolledOverId = newId;
                }
            }
        }

        private void handleMoveForHeader(MouseEvent e) {
            if (!SubstanceTableUI.this.table.getColumnSelectionAllowed()) {
                return;
            }
            JTableHeader header = SubstanceTableUI.this.table.getTableHeader();
            if (header == null || !header.isVisible()) {
                return;
            }
            TableHeaderUI ui = header.getUI();
            if (!(ui instanceof SubstanceTableHeaderUI)) {
                return;
            }
            SubstanceTableHeaderUI sthui = (SubstanceTableHeaderUI)ui;
            int row = SubstanceTableUI.this.table.rowAtPoint(e.getPoint());
            int column = SubstanceTableUI.this.table.columnAtPoint(e.getPoint());
            if (row < 0 || row >= SubstanceTableUI.this.table.getRowCount() || column < 0 || column >= SubstanceTableUI.this.table.getColumnCount()) {
                this.fadeOutTableHeader();
                SubstanceTableUI.this.rolledOverColumn = -1;
            } else {
                if (SubstanceTableUI.this.rolledOverColumn == column) {
                    return;
                }
                this.fadeOutTableHeader();
                FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)header, column, false, sthui.getCallback(column));
                if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ROLLOVER, SubstanceTableUI.this.table)) {
                    SubstanceTableUI.this.rolledOverColumn = column;
                }
            }
        }

        private void fadeOut() {
            if (SubstanceTableUI.this.rolledOverId != null) {
                FadeTrackerCallback callback = SubstanceTableUI.this.getCallback(SubstanceTableUI.this.rolledOverId);
                if (SubstanceTableUI.this._hasRolloverAnimations()) {
                    FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceTableUI.this.table, SubstanceTableUI.this.rolledOverId, false, callback);
                } else {
                    callback.fadeEnded(FadeKind.ROLLOVER);
                }
            }
        }

        private void fadeOutTableHeader() {
            if (SubstanceTableUI.this.rolledOverColumn >= 0) {
                JTableHeader header = SubstanceTableUI.this.table.getTableHeader();
                if (header == null || !header.isVisible()) {
                    return;
                }
                SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)header.getUI();
                FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)header, SubstanceTableUI.this.rolledOverColumn, false, ui.getCallback(SubstanceTableUI.this.rolledOverColumn));
            }
        }
    }

    protected class TableStateListener
    implements ListSelectionListener,
    TableModelListener {
        protected TableStateListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubstanceTableUI.this.syncSelection();
                }
            });
        }

        @Override
        public void tableChanged(final TableModelEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    if (e.getType() != 0) {
                        SubstanceTableUI.this.selectedIndices.clear();
                        SubstanceTableUI.this.prevStateMap.clear();
                        SubstanceTableUI.this.nextStateMap.clear();
                        SubstanceTableUI.this.focusedColumn = -1;
                        SubstanceTableUI.this.focusedRow = -1;
                    }
                    SubstanceTableUI.this.syncSelection();
                    SubstanceTableUI.this.table.repaint();
                }
            });
        }
    }

    protected static class TableRowId
    implements TableId {
        protected int row;

        public TableRowId(int row) {
            this.row = row;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.row == otherId.row) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableRowId) {
                TableRowId otherId = (TableRowId)o;
                if (this.row == otherId.row) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.row ^ this.row >>> 32;
        }

        @Override
        public TableId cloneId() {
            return new TableRowId(this.row);
        }
    }

    protected static class TableColumnId
    implements TableId {
        protected int column;

        public TableColumnId(int column) {
            this.column = column;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            if (o instanceof TableColumnId) {
                TableColumnId otherId = (TableColumnId)o;
                if (this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.column ^ this.column >>> 32;
        }

        @Override
        public TableId cloneId() {
            return new TableColumnId(this.column);
        }
    }

    public static class TableCellId
    implements TableId {
        protected int row;
        protected int column;
        protected boolean isExactComparison;

        public TableCellId(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public void setExactComparison(boolean isExactComparison) {
            this.isExactComparison = isExactComparison;
        }

        public int compareTo(Object o) {
            if (o instanceof TableCellId) {
                TableCellId otherId = (TableCellId)o;
                if (this.row == otherId.row && this.column == otherId.column) {
                    return 0;
                }
                return 1;
            }
            if (!this.isExactComparison) {
                if (o instanceof TableRowId) {
                    TableRowId otherId = (TableRowId)o;
                    if (this.row == otherId.row) {
                        return 0;
                    }
                    return 1;
                }
                if (o instanceof TableColumnId) {
                    TableColumnId otherId = (TableColumnId)o;
                    if (this.column == otherId.column) {
                        return 0;
                    }
                    return 1;
                }
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return (this.row ^ this.row >>> 32) & (this.column ^ this.column >>> 32);
        }

        public String toString() {
            return this.row + ":" + this.column;
        }

        @Override
        public TableId cloneId() {
            return new TableCellId(this.row, this.column);
        }
    }

    public static interface TableId
    extends Comparable {
        public TableId cloneId();
    }

    protected class ColumnRepaintCallback
    extends UIThreadFadeTrackerAdapter {
        protected JTable table;
        protected int columnIndex;

        public ColumnRepaintCallback(JTable table, int columnIndex) {
            this.table = table;
            this.columnIndex = columnIndex;
        }

        @Override
        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableUI.this.table == this.table && this.columnIndex < this.table.getColumnCount()) {
                for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
                    TableCellId cellIndex = new TableCellId(rowIndex, this.columnIndex);
                    ComponentState currState = SubstanceTableUI.this.getCellState(cellIndex);
                    if (currState == ComponentState.DEFAULT) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        SubstanceTableUI.this.nextStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, currState);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, currState);
                }
            }
            this.repaintColumn();
        }

        @Override
        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableUI.this.table == this.table && this.columnIndex < this.table.getColumnCount()) {
                for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
                    TableCellId cellIndex = new TableCellId(rowIndex, this.columnIndex);
                    ComponentState nextState = (ComponentState)((Object)SubstanceTableUI.this.nextStateMap.get(cellIndex));
                    if (nextState == null) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, nextState);
                }
            }
            this.repaintColumn();
        }

        @Override
        public void fadePerformed(FadeKind fadeKind, float fade) {
            if (SubstanceTableUI.this.table == this.table && this.columnIndex < this.table.getColumnCount()) {
                for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
                    TableCellId cellIndex = new TableCellId(rowIndex, this.columnIndex);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, SubstanceTableUI.this.getCellState(cellIndex));
                }
            }
            this.repaintColumn();
        }

        private void repaintColumn() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int columnCount = ColumnRepaintCallback.this.table.getColumnCount();
                    if (columnCount > 0 && ColumnRepaintCallback.this.columnIndex < columnCount) {
                        Rectangle rect = ColumnRepaintCallback.this.table.getCellRect(0, ColumnRepaintCallback.this.columnIndex, true);
                        for (int i = 1; i < ColumnRepaintCallback.this.table.getRowCount(); ++i) {
                            rect = rect.union(ColumnRepaintCallback.this.table.getCellRect(i, ColumnRepaintCallback.this.columnIndex, true));
                        }
                        if (!ColumnRepaintCallback.this.table.getShowHorizontalLines() && !ColumnRepaintCallback.this.table.getShowVerticalLines()) {
                            float extra = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(ColumnRepaintCallback.this.table.getTableHeader()));
                            rect.x -= (int)extra;
                            rect.width += 2 * (int)extra;
                        }
                        ColumnRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }

    protected class RowRepaintCallback
    extends UIThreadFadeTrackerAdapter {
        protected JTable table;
        protected int rowIndex;

        public RowRepaintCallback(JTable table, int rowIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
        }

        @Override
        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount()) {
                for (int columnIndex = 0; columnIndex < this.table.getColumnCount(); ++columnIndex) {
                    TableCellId cellIndex = new TableCellId(this.rowIndex, columnIndex);
                    ComponentState currState = SubstanceTableUI.this.getCellState(cellIndex);
                    if (currState == ComponentState.DEFAULT) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        SubstanceTableUI.this.nextStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, currState);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, currState);
                }
            }
            this.repaintRow();
        }

        @Override
        public void fadePerformed(FadeKind fadeKind, float fade) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount()) {
                for (int columnIndex = 0; columnIndex < this.table.getColumnCount(); ++columnIndex) {
                    TableCellId cellIndex = new TableCellId(this.rowIndex, columnIndex);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, SubstanceTableUI.this.getCellState(cellIndex));
                }
            }
            this.repaintRow();
        }

        @Override
        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount()) {
                for (int columnIndex = 0; columnIndex < this.table.getColumnCount(); ++columnIndex) {
                    TableCellId cellIndex = new TableCellId(this.rowIndex, columnIndex);
                    ComponentState nextState = (ComponentState)((Object)SubstanceTableUI.this.nextStateMap.get(cellIndex));
                    if (nextState == null) {
                        SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                        continue;
                    }
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, nextState);
                }
            }
            this.repaintRow();
        }

        private void repaintRow() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int rowCount = RowRepaintCallback.this.table.getRowCount();
                    if (rowCount > 0 && RowRepaintCallback.this.rowIndex < rowCount) {
                        Rectangle rect = RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, 0, true);
                        for (int i = 1; i < RowRepaintCallback.this.table.getColumnCount(); ++i) {
                            rect = rect.union(RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, i, true));
                        }
                        if (!RowRepaintCallback.this.table.getShowHorizontalLines() && !RowRepaintCallback.this.table.getShowVerticalLines()) {
                            float extra = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(RowRepaintCallback.this.table.getTableHeader()));
                            rect.y -= (int)extra;
                            rect.height += 2 * (int)extra;
                        }
                        RowRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }

    protected class CellRepaintCallback
    extends UIThreadFadeTrackerAdapter {
        protected JTable table;
        protected int rowIndex;
        protected int columnIndex;

        public CellRepaintCallback(JTable table, int rowIndex, int columnIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        @Override
        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount() && this.columnIndex < this.table.getColumnCount()) {
                TableCellId cellIndex = new TableCellId(this.rowIndex, this.columnIndex);
                ComponentState currState = SubstanceTableUI.this.getCellState(cellIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                    SubstanceTableUI.this.nextStateMap.remove(cellIndex);
                } else {
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, currState);
                    SubstanceTableUI.this.nextStateMap.put(cellIndex, currState);
                }
            }
            this.repaintCell();
        }

        @Override
        public void fadePerformed(FadeKind fadeKind, float fade) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount() && this.columnIndex < this.table.getColumnCount()) {
                TableCellId cellIndex = new TableCellId(this.rowIndex, this.columnIndex);
                SubstanceTableUI.this.nextStateMap.put(cellIndex, SubstanceTableUI.this.getCellState(cellIndex));
            }
            this.repaintCell();
        }

        @Override
        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTableUI.this.table == this.table && this.rowIndex < this.table.getRowCount() && this.columnIndex < this.table.getColumnCount()) {
                TableCellId cellIndex = new TableCellId(this.rowIndex, this.columnIndex);
                ComponentState nextState = (ComponentState)((Object)SubstanceTableUI.this.nextStateMap.get(cellIndex));
                if (nextState == null) {
                    SubstanceTableUI.this.prevStateMap.remove(cellIndex);
                } else {
                    SubstanceTableUI.this.prevStateMap.put(cellIndex, nextState);
                }
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int rowCount = CellRepaintCallback.this.table.getRowCount();
                    int colCount = CellRepaintCallback.this.table.getColumnCount();
                    if (rowCount > 0 && CellRepaintCallback.this.rowIndex < rowCount && colCount > 0 && CellRepaintCallback.this.columnIndex < colCount) {
                        Rectangle rect = CellRepaintCallback.this.table.getCellRect(CellRepaintCallback.this.rowIndex, CellRepaintCallback.this.columnIndex, true);
                        if (!CellRepaintCallback.this.table.getShowHorizontalLines() && !CellRepaintCallback.this.table.getShowVerticalLines()) {
                            float extra = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(CellRepaintCallback.this.table.getTableHeader()));
                            rect.x -= (int)extra;
                            rect.width += 2 * (int)extra;
                            rect.y -= (int)extra;
                            rect.height += 2 * (int)extra;
                        }
                        CellRepaintCallback.this.table.repaint(rect);
                    }
                }
            });
        }
    }
}

