/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.painter.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.jvnet.substance.api.ColorSchemeSingleColorQuery;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.painter.border.FractionBasedBorderPainter;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceArrowButton;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class DelegateFractionBasedBorderPainter
implements SubstanceBorderPainter {
    protected String displayName;
    protected FractionBasedBorderPainter delegate;
    protected int[] masks;
    protected ColorSchemeTransform transform;
    protected static final LazyResettableHashMap<SubstanceColorScheme> transformMap = new LazyResettableHashMap("DelegateBorderPainter");

    public DelegateFractionBasedBorderPainter(String displayName, FractionBasedBorderPainter delegate, int[] masks, ColorSchemeTransform transform) {
        this.displayName = displayName;
        this.delegate = delegate;
        this.masks = new int[masks.length];
        System.arraycopy(masks, 0, this.masks, 0, masks.length);
        this.transform = transform;
    }

    @Override
    public boolean isPaintingInnerContour() {
        return false;
    }

    @Override
    public void paintBorder(Graphics g, Component c, int width, int height, Shape contour, Shape innerContour, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean useCyclePosAsInterpolation) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        SubstanceColorScheme interpolationScheme1 = colorScheme1;
        SubstanceColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        interpolationScheme1 = this.getShiftScheme(interpolationScheme1);
        interpolationScheme2 = this.getShiftScheme(interpolationScheme2);
        double cycleCoef = 1.0 - (double)cyclePos;
        float[] fractions = this.delegate.getFractions();
        ColorSchemeSingleColorQuery[] colorQueries = this.delegate.getColorQueries();
        Color[] fillColors = new Color[fractions.length];
        for (int i = 0; i < fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = colorQueries[i];
            Color color1 = colorQuery.query(interpolationScheme1);
            Color color2 = colorQuery.query(interpolationScheme2);
            color1 = new Color(this.masks[i] & color1.getRGB(), true);
            color2 = new Color(this.masks[i] & color2.getRGB(), true);
            fillColors[i] = !useCyclePosAsInterpolation ? color1 : SubstanceColorUtilities.getInterpolatedColor(color1, color2, cycleCoef);
        }
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        boolean isSpecialButton = c == null ? false : c.getClass().isAnnotationPresent(SubstanceArrowButton.class);
        int joinKind = isSpecialButton ? 0 : 1;
        int capKind = isSpecialButton ? 2 : 0;
        graphics.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(gradient);
        graphics.draw(contour);
        graphics.dispose();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private SubstanceColorScheme getShiftScheme(SubstanceColorScheme orig) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(orig.getDisplayName(), this.getDisplayName(), this.transform);
        if (!transformMap.containsKey(key)) {
            transformMap.put(key, this.transform.transform(orig));
        }
        return transformMap.get(key);
    }
}

