/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.painter.fill;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Shape;
import org.jvnet.substance.api.ColorSchemeSingleColorQuery;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.painter.FractionBasedPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class FractionBasedFillPainter
extends FractionBasedPainter
implements SubstanceGradientPainter {
    public FractionBasedFillPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        super(displayName, fractions, colorQueries);
    }

    @Override
    public void paintContourBackground(Graphics g, Component comp, int width, int height, Shape contour, boolean isFocused, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceColorScheme interpolationScheme1 = colorScheme1;
        SubstanceColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos;
        Color[] fillColors = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            Color color1 = colorQuery.query(interpolationScheme1);
            Color color2 = colorQuery.query(interpolationScheme2);
            fillColors[i] = !useCyclePosAsInterpolation ? color1 : SubstanceColorUtilities.getInterpolatedColor(color1, color2, cycleCoef);
        }
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, this.fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(gradient);
        graphics.fill(contour);
        graphics.dispose();
    }
}

