/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.colorscheme;

import java.awt.Color;
import org.jvnet.substance.api.SchemeDerivedColors;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.colorscheme.DerivedColorsResolverDark;
import org.jvnet.substance.colorscheme.DerivedColorsResolverLight;
import org.jvnet.substance.colorscheme.HueShiftColorScheme;
import org.jvnet.substance.colorscheme.InvertedColorScheme;
import org.jvnet.substance.colorscheme.NegatedColorScheme;
import org.jvnet.substance.colorscheme.SaturatedColorScheme;
import org.jvnet.substance.colorscheme.ShadeColorScheme;
import org.jvnet.substance.colorscheme.ShiftColorScheme;
import org.jvnet.substance.colorscheme.TintColorScheme;
import org.jvnet.substance.colorscheme.ToneColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public abstract class BaseColorScheme
implements SubstanceColorScheme {
    protected boolean isDark;
    protected String displayName;
    protected SchemeDerivedColors derivedColorsResolver;

    protected BaseColorScheme(String displayName, boolean isDark) {
        this.displayName = displayName;
        this.isDark = isDark;
        this.derivedColorsResolver = this.isDark ? new DerivedColorsResolverDark(this) : new DerivedColorsResolverLight(this);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isDark() {
        return this.isDark;
    }

    @Override
    public SubstanceColorScheme shift(Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor) {
        return new ShiftColorScheme(this, backgroundShiftColor, backgroundShiftFactor, foregroundShiftColor, foregroundShiftFactor, true);
    }

    @Override
    public SubstanceColorScheme shiftBackground(Color backgroundShiftColor, double backgroundShiftFactor) {
        return this.shift(backgroundShiftColor, backgroundShiftFactor, null, 0.0);
    }

    @Override
    public SubstanceColorScheme tint(double tintFactor) {
        return new TintColorScheme(this, tintFactor);
    }

    @Override
    public SubstanceColorScheme tone(double toneFactor) {
        return new ToneColorScheme(this, toneFactor);
    }

    @Override
    public SubstanceColorScheme shade(double shadeFactor) {
        return new ShadeColorScheme(this, shadeFactor);
    }

    @Override
    public SubstanceColorScheme saturate(double saturateFactor) {
        return new SaturatedColorScheme(this, saturateFactor);
    }

    @Override
    public SubstanceColorScheme invert() {
        return new InvertedColorScheme(this);
    }

    @Override
    public SubstanceColorScheme negate() {
        return new NegatedColorScheme(this);
    }

    @Override
    public SubstanceColorScheme hueShift(double hueShiftFactor) {
        return new HueShiftColorScheme(this, hueShiftFactor);
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.derivedColorsResolver.getBackgroundFillColor();
    }

    @Override
    public Color getFocusRingColor() {
        return this.derivedColorsResolver.getFocusRingColor();
    }

    @Override
    public Color getLineColor() {
        return this.derivedColorsResolver.getLineColor();
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.derivedColorsResolver.getSelectionForegroundColor();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.derivedColorsResolver.getSelectionBackgroundColor();
    }

    @Override
    public Color getWatermarkDarkColor() {
        return this.derivedColorsResolver.getWatermarkDarkColor();
    }

    @Override
    public Color getWatermarkLightColor() {
        return this.derivedColorsResolver.getWatermarkLightColor();
    }

    @Override
    public Color getWatermarkStampColor() {
        return this.derivedColorsResolver.getWatermarkStampColor();
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return this.derivedColorsResolver.getTextBackgroundFillColor();
    }

    @Override
    public SubstanceColorScheme named(String colorSchemeDisplayName) {
        this.displayName = colorSchemeDisplayName;
        return this;
    }

    public String toString() {
        return this.getDisplayName() + " {\n    kind=" + (this.isDark() ? "Dark" : "Light") + "\n    colorUltraLight=" + SubstanceColorUtilities.encode(this.getUltraLightColor()) + "\n    colorExtraLight=" + SubstanceColorUtilities.encode(this.getExtraLightColor()) + "\n    colorLight=" + SubstanceColorUtilities.encode(this.getLightColor()) + "\n    colorMid=" + SubstanceColorUtilities.encode(this.getMidColor()) + "\n    colorDark=" + SubstanceColorUtilities.encode(this.getDarkColor()) + "\n    colorUltraDark=" + SubstanceColorUtilities.encode(this.getUltraDarkColor()) + "\n    colorForeground=" + SubstanceColorUtilities.encode(this.getForegroundColor()) + "\n}";
    }
}

