/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.colorscheme;

import java.awt.Color;
import org.jvnet.substance.api.SchemeDerivedColors;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class DerivedColorsResolverLight
implements SchemeDerivedColors {
    SubstanceColorScheme scheme;

    public DerivedColorsResolverLight(SubstanceColorScheme scheme) {
        if (scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be light: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    @Override
    public Color getWatermarkStampColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getMidColor(), 50);
    }

    @Override
    public Color getWatermarkLightColor() {
        return this.scheme.getLightColor();
    }

    @Override
    public Color getWatermarkDarkColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getDarkColor(), 15);
    }

    @Override
    public Color getLineColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getDarkColor(), 0.7);
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.scheme.getUltraDarkColor().darker().darker();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.scheme.getExtraLightColor();
    }

    public String toString() {
        return this.scheme.getDisplayName();
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getFocusRingColor() {
        return this.scheme.getDarkColor();
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getUltraLightColor(), this.scheme.getExtraLightColor(), 0.8);
    }
}

