/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.utils.DecorationPainterUtils;
import org.jvnet.substance.painter.utils.OverlayPainterUtils;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class BackgroundPaintingUtils {
    public static void updateIfOpaque(Graphics g, Component c) {
        if (TransitionLayout.isOpaque(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
    }

    public static void update(Graphics g, Component c, boolean force) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, g));
        DecorationAreaType decorationType = SubstanceLookAndFeel.getDecorationType(c);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        if (decorationType != null && skin.isRegisteredAsDecorationArea(decorationType)) {
            DecorationPainterUtils.paintDecorationBackground(graphics, c, force);
            OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
        } else {
            Color backgr = SubstanceColorUtilities.getBackgroundFillColor(c);
            graphics.setColor(backgr);
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
            SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
            if (watermark != null && !isPreviewMode && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
                watermark.drawWatermarkImage(graphics, c, 0, 0, c.getWidth(), c.getHeight());
            }
        }
        graphics.dispose();
    }

    public static void fillAndWatermark(Graphics g, JComponent c, Color fillColor, Rectangle rect) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, g));
        graphics.setColor(fillColor);
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, 1.0f, g));
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
        if (watermark != null && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
            watermark.drawWatermarkImage(graphics, c, rect.x, rect.y, rect.width, rect.height);
        }
        graphics.dispose();
    }
}

