/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.ColorSchemeSingleColorQuery;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.jvnet.substance.api.painter.overlay.TopShadowOverlayPainter;
import org.jvnet.substance.painter.border.FlatBorderPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MarbleNoiseDecorationPainter;
import org.jvnet.substance.painter.gradient.SubduedGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;

public class NebulaSkin
extends SubstanceSkin {
    public static final String NAME = "Nebula";
    private BottomLineOverlayPainter bottomLineOverlayPainter;

    public NebulaSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes(NebulaSkin.class.getClassLoader().getResource("org/jvnet/substance/skin/nebula.colorschemes"));
        SubstanceColorScheme activeScheme = schemes.get("Nebula Active");
        SubstanceColorScheme defaultScheme = schemes.get("Nebula Default");
        SubstanceColorScheme rolloverUnselectedScheme = schemes.get("Nebula Rollover Unselected");
        SubstanceColorScheme pressedScheme = schemes.get("Nebula Pressed");
        SubstanceColorScheme rolloverSelectedScheme = schemes.get("Nebula Rollover Selected");
        SubstanceColorScheme disabledScheme = schemes.get("Nebula Disabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        defaultSchemeBundle.registerColorScheme(rolloverUnselectedScheme, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(rolloverSelectedScheme, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerColorScheme(pressedScheme, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultSchemeBundle.registerHighlightColorScheme(pressedScheme, 0.6f, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(pressedScheme, 0.8f, ComponentState.SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(pressedScheme, 0.95f, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(pressedScheme, 0.8f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerAsDecorationArea(activeScheme.saturate(-0.5), DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL);
        this.addOverlayPainter(TopShadowOverlayPainter.getInstance(), DecorationAreaType.TOOLBAR);
        this.bottomLineOverlayPainter = new BottomLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            @Override
            public Color query(SubstanceColorScheme scheme) {
                Color dark = scheme.getDarkColor();
                return new Color(dark.getRed(), dark.getGreen(), dark.getBlue(), 160);
            }
        });
        this.addOverlayPainter(this.bottomLineOverlayPainter, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER);
        this.buttonShaper = new ClassicButtonShaper();
        this.gradientPainter = new SubduedGradientPainter();
        MarbleNoiseDecorationPainter decorationPainter = new MarbleNoiseDecorationPainter();
        decorationPainter.setBaseDecorationPainter(new ArcDecorationPainter());
        decorationPainter.setTextureAlpha(0.3f);
        this.decorationPainter = decorationPainter;
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new FlatBorderPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

