/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceEtchedBorder
implements Border {
    public Color getHighlightColor(Component c) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(c, ColorSchemeAssociationKind.SEPARATOR, ComponentState.DEFAULT);
        boolean isDark = colorScheme.isDark();
        Color foreDark = isDark ? colorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getMidColor(), colorScheme.getDarkColor(), 0.4);
        return SubstanceColorUtilities.getAlphaColor(foreDark, 196);
    }

    public Color getShadowColor(Component c) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(c, ColorSchemeAssociationKind.SEPARATOR, ComponentState.DEFAULT);
        Color back = colorScheme.isDark() ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        return SubstanceColorUtilities.getAlphaColor(back, 196);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        Graphics2D g2d = (Graphics2D)g.create();
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        g2d.setStroke(new BasicStroke(strokeWidth, 0, 1));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        g2d.setColor(this.getShadowColor(c));
        int delta = (int)Math.floor((double)strokeWidth / 2.0);
        g2d.draw(new Rectangle2D.Float(delta, delta, (float)(w - delta) - 2.0f * strokeWidth, (float)(h - delta) - 2.0f * strokeWidth));
        g2d.setColor(this.getHighlightColor(c));
        g2d.draw(new Line2D.Float(strokeWidth, (float)h - 3.0f * strokeWidth, strokeWidth, strokeWidth));
        g2d.draw(new Line2D.Float((float)delta + strokeWidth, (float)delta + strokeWidth, (float)(w - delta) - 3.0f * strokeWidth, (float)delta + strokeWidth));
        g2d.draw(new Line2D.Float(delta, (float)(h - delta) - strokeWidth, (float)(w - delta) - strokeWidth, (float)(h - delta) - strokeWidth));
        g2d.draw(new Line2D.Float((float)(w - delta) - strokeWidth, (float)(h - delta) - strokeWidth, (float)(w - delta) - strokeWidth, delta));
        g2d.dispose();
        RenderingUtils.installDesktopHints((Graphics2D)g, c);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        return new Insets(prefSize, prefSize, prefSize, prefSize);
    }
}

