/*
 * Decompiled with CFR 0.152.
 */
package updater;

import com.jhlabs.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;

public class Splash {
    private static String[] arguments = null;
    private static String downloadUrl = "https://www.alora.io/downloads/client.zip";
    private static String playercountUrl = "https://www.alora.io/api/playercount";
    private static String downloadUrl2 = "https://dl.dropboxusercontent.com/s/m8u4ou8bxzh2lk1/client.zip?dl=0";
    private static String fileName = "client.zip";
    private static String jarFileName = "client.jar";
    private static String jarFileNameRuneLite = "client_runelite.jar";
    private static String serverName = "Alora";
    private static String saveDirectory = System.getProperty("user.home") + File.separator + "alora" + File.separator;
    private JLabel imglabel;
    private JLabel imglabel2;
    private JLabel announcement;
    private JFrame frame;
    public static URL url;
    private static JProgressBar pbar;
    private static JButton playVanillaButton;
    private static JButton playRuneliteButton;
    private static final int FRAME_WIDTH = 700;
    private static final int FRAME_HEIGHT = 450;
    private static final int LOGO_WIDTH = 541;
    private static final int LOGO_HEIGHT = 141;
    private static boolean downloadedLatestClient;
    int updateSelection = -1;
    static int hdSelection;
    private static final boolean isMac;
    private static final boolean isWindows;
    private static boolean forceLatestJava;

    public static void main(String[] args) {
        arguments = args;
        new Splash();
    }

    public Splash() {
        final URL location = this.getClass().getResource("/img/alora_icon_large.png");
        if (Splash.isMac()) {
            try {
                String className = "com.apple.eawt.Application";
                Class<?> cls = Class.forName(className);
                Object application = cls.newInstance().getClass().getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                application.getClass().getMethod("setDockIconImage", Image.class).invoke(application, Toolkit.getDefaultToolkit().getImage(location));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedImage img;
                    Splash.this.frame = new JFrame("Launcher");
                    try {
                        UIManager.setLookAndFeel("org.jvnet.substance.skin.SubstanceRavenGraphiteGlassLookAndFeel");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Splash.this.frame = new JFrame("Alora Launcher");
                    Splash.this.frame.setUndecorated(true);
                    Splash.this.frame.setBackground(new Color(0, 0, 0, 0));
                    Splash.this.frame.setLayout(new GridBagLayout());
                    Splash.this.frame.setDefaultCloseOperation(3);
                    Splash.this.frame.setContentPane(new ShadowPane());
                    Splash.this.frame.setLayout(new BorderLayout());
                    if (Splash.isWindows()) {
                        try {
                            Splash.this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(location));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    FrameDragListener frameDragListener = new FrameDragListener(Splash.this.frame);
                    Splash.this.frame.addMouseListener(frameDragListener);
                    Splash.this.frame.addMouseMotionListener(frameDragListener);
                    URL location3 = this.getClass().getResource("/img/bg.gif");
                    Splash.this.imglabel = new JLabel(new ImageIcon(location3));
                    Splash.this.frame.add(Splash.this.imglabel);
                    URL location2 = this.getClass().getResource("/img/logo.png");
                    Splash.this.imglabel2 = new JLabel(new ImageIcon(location2));
                    Splash.this.imglabel.add(Splash.this.imglabel2);
                    Thread playercountThread = new Thread(){

                        @Override
                        public void run() {
                            String playercount = "";
                            try {
                                playercount = Splash.readStringFromURL(playercountUrl);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            if (playercount == null || playercount.length() <= 0) {
                                playercount = "600";
                            }
                            final String finalPlayercount = playercount;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Splash.this.announcement = new JLabel("<html>There are currently <b>" + finalPlayercount + "</b> players online.&nbsp;&nbsp;&nbsp;&nbsp;</html>", 4);
                                    Splash.this.announcement.setBounds(0, 10, 700, 20);
                                    Splash.this.announcement.setBackground(new Color(255, 0, 0, 128));
                                    Splash.this.announcement.setFont(new Font("Trebuchet", 0, 14));
                                    Splash.this.announcement.setForeground(Color.WHITE);
                                    Splash.this.imglabel.add(Splash.this.announcement);
                                }
                            });
                        }
                    };
                    playercountThread.start();
                    Splash.this.imglabel2.setPreferredSize(new Dimension(541, 141));
                    Splash.this.imglabel2.setHorizontalAlignment(0);
                    Splash.this.imglabel2.setVerticalAlignment(0);
                    Splash.this.imglabel2.setBounds(79, 124, 541, 141);
                    pbar = new JProgressBar();
                    pbar.setMinimum(0);
                    pbar.setMaximum(1000);
                    pbar.setStringPainted(true);
                    pbar.setString("Checking for updates...");
                    pbar.setFont(new Font("Trebuchet", 0, 12));
                    pbar.setValue(0);
                    Splash.this.imglabel.add(pbar);
                    pbar.setPreferredSize(new Dimension(700, 35));
                    pbar.setBounds(0, 405, 700, 45);
                    playRuneliteButton = new JButton();
                    playRuneliteButton.setText("<html>Play with <b>RuneLite</b></html>");
                    try {
                        img = ImageIO.read(this.getClass().getResource("/img/rl_icon_small.png"));
                        playRuneliteButton.setIcon(new ImageIcon(img));
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                    }
                    playRuneliteButton.setEnabled(false);
                    Splash.this.imglabel.add(playRuneliteButton);
                    playRuneliteButton.setPreferredSize(new Dimension(350, 45));
                    playRuneliteButton.setBounds(0, 363, 350, 45);
                    playVanillaButton = new JButton();
                    playVanillaButton.setText("<html>Play Regular Client</html>");
                    try {
                        img = ImageIO.read(this.getClass().getResource("/img/alora_icon_small.png"));
                        playVanillaButton.setIcon(new ImageIcon(img));
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                    }
                    playVanillaButton.setEnabled(false);
                    Splash.this.imglabel.add(playVanillaButton);
                    playVanillaButton.setPreferredSize(new Dimension(350, 45));
                    playVanillaButton.setBounds(350, 363, 350, 45);
                    playVanillaButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        Splash.startApplication(jarFileName);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                }
                            };
                            t.start();
                        }
                    });
                    playRuneliteButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        Splash.startApplication(jarFileNameRuneLite);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                }
                            };
                            t.start();
                        }
                    });
                    Splash.this.frame.pack();
                    Splash.this.frame.toFront();
                    Splash.this.frame.setLocationRelativeTo(null);
                    Splash.this.frame.setVisible(true);
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            for (int attempt = 0; attempt < 2; ++attempt) {
                                boolean needsUpdate;
                                block43: {
                                    System.out.println("ATTEMPT #" + (attempt + 1));
                                    needsUpdate = false;
                                    File zipFile = new File(saveDirectory + fileName);
                                    try {
                                        url = new URL(attempt == 0 ? downloadUrl : downloadUrl2);
                                    }
                                    catch (MalformedURLException e) {
                                        e.printStackTrace();
                                    }
                                    File theDir = new File(saveDirectory);
                                    try {
                                        theDir.mkdir();
                                    }
                                    catch (SecurityException securityException) {
                                        // empty catch block
                                    }
                                    try {
                                        if (zipFile.exists()) {
                                            System.out.println("Client zip exists.");
                                            try {
                                                File client;
                                                File libs;
                                                SSLContext ctx = SSLContext.getInstance("TLS");
                                                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                                                SSLContext.setDefault(ctx);
                                                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                                                connection.setConnectTimeout(10000);
                                                connection.setReadTimeout(10000);
                                                connection.setHostnameVerifier(new HostnameVerifier(){

                                                    @Override
                                                    public boolean verify(String arg0, SSLSession arg1) {
                                                        return true;
                                                    }
                                                });
                                                connection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
                                                connection.connect();
                                                long time = connection.getLastModified();
                                                if (time > zipFile.lastModified()) {
                                                    needsUpdate = true;
                                                }
                                                System.out.println("Remote zip timestamp: " + time + ", local zip timestamp: " + zipFile.lastModified() + ", needsUpdate: " + needsUpdate);
                                                System.out.println("Content length: " + connection.getContentLength() + ", local file length: " + zipFile.length());
                                                if (connection.getContentLength() > 0 && (long)connection.getContentLength() != zipFile.length()) {
                                                    needsUpdate = true;
                                                    System.out.println("Content length mismatch. Needs update.");
                                                }
                                                if (time > zipFile.lastModified()) {
                                                    needsUpdate = true;
                                                    System.out.println("Newer remote file. Needs update.");
                                                }
                                                if (!(libs = new File(saveDirectory + "clientlibs.jar")).exists()) {
                                                    needsUpdate = true;
                                                    System.out.println("Libraries missing. Needs update.");
                                                }
                                                if (!(client = new File(saveDirectory + fileName)).exists()) {
                                                    needsUpdate = true;
                                                    System.out.println("Client zip missing. Needs update.");
                                                }
                                                connection.disconnect();
                                                if (needsUpdate) {
                                                    System.out.println("Local file is old. Asking to download update...");
                                                    Splash.this.startUpdateConfirmation();
                                                    while (Splash.this.updateSelection == -1) {
                                                        Thread.sleep(10L);
                                                    }
                                                    System.out.println("Update Selection: " + Splash.this.updateSelection);
                                                    if (Splash.this.updateSelection == 2) {
                                                        Splash.unlockButtons();
                                                        needsUpdate = false;
                                                        return;
                                                    }
                                                    break block43;
                                                }
                                                System.out.println("Local file is latest. Starting application.");
                                                if (!downloadedLatestClient) {
                                                    int i = 0;
                                                    while (i <= 1000) {
                                                        final int finalInt = i++;
                                                        SwingUtilities.invokeLater(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                pbar.setValue(finalInt);
                                                                if (finalInt == 1000) {
                                                                    pbar.setString("Your client is up to date!");
                                                                }
                                                            }
                                                        });
                                                        Thread.sleep(2L);
                                                    }
                                                    Thread.sleep(1000L);
                                                } else {
                                                    SwingUtilities.invokeLater(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            pbar.setValue(1000);
                                                        }
                                                    });
                                                    Thread.sleep(1000L);
                                                }
                                                Splash.unlockButtons();
                                                return;
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                                System.err.println("Failed to check remote file. Attempting second URL.");
                                            }
                                            break block43;
                                        }
                                        System.out.println("Client zip does not exist.");
                                        needsUpdate = true;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        System.err.println("Failed initial check. Attempting second URL.");
                                    }
                                }
                                if (!needsUpdate) continue;
                                OutputStream dest = null;
                                InputStream readFileToDownload = null;
                                boolean error = false;
                                try {
                                    int numRead;
                                    SSLContext ctx = SSLContext.getInstance("TLS");
                                    ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                                    SSLContext.setDefault(ctx);
                                    System.out.println("Downloading zip...");
                                    dest = new BufferedOutputStream(new FileOutputStream(saveDirectory + fileName));
                                    HttpsURLConnection download = (HttpsURLConnection)url.openConnection();
                                    download.setConnectTimeout(10000);
                                    download.setReadTimeout(10000);
                                    download.setHostnameVerifier(new HostnameVerifier(){

                                        @Override
                                        public boolean verify(String arg0, SSLSession arg1) {
                                            return true;
                                        }
                                    });
                                    download.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
                                    readFileToDownload = download.getInputStream();
                                    byte[] data = new byte[2048];
                                    long numWritten = 0L;
                                    int length = download.getContentLength();
                                    while ((numRead = readFileToDownload.read(data)) != -1) {
                                        dest.write(data, 0, numRead);
                                        final int percent = (int)((double)(numWritten += (long)numRead) / (double)length * 100.0) * 10;
                                        try {
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    pbar.setValue(percent);
                                                    pbar.setString((percent < 990 ? "Downloading " + serverName + " - " + percent / 10 + "%" : "Download complete! Preparing client...") + "");
                                                }
                                            });
                                        }
                                        catch (Exception r) {
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    pbar.setValue(percent);
                                                    pbar.setString((percent < 990 ? "Downloading " + serverName + " - " + percent / 10 + "%" : "Download complete! Preparing client...") + "");
                                                }
                                            });
                                        }
                                    }
                                    if (download != null) {
                                        download.disconnect();
                                    }
                                    if (readFileToDownload != null) {
                                        readFileToDownload.close();
                                    }
                                    if (dest != null) {
                                        dest.close();
                                    }
                                    System.out.println("New zip file successfully downloaded.");
                                    try {
                                        downloadedLatestClient = true;
                                        needsUpdate = false;
                                        Splash.unzip(saveDirectory + fileName, saveDirectory);
                                        System.out.println("Unzipping " + fileName + " to " + saveDirectory);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        error = true;
                                        System.err.println("Failed to unzip. Attempting another URL.");
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    error = true;
                                    System.err.println("Failed to download new client. Attempting another URL.");
                                    continue;
                                }
                                finally {
                                    try {
                                        if (readFileToDownload != null) {
                                            readFileToDownload.close();
                                        }
                                        if (dest != null) {
                                            dest.close();
                                        }
                                        if (!error || attempt != 0) {
                                            Thread.sleep(1000L);
                                            Splash.unlockButtons();
                                            return;
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                    };
                    t.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void unzip(String source, String destination) {
        System.out.println("Zip file: " + source);
        System.out.println("Zip destination:  " + destination);
        try {
            ZipFile zipFile = new ZipFile(source);
            zipFile.extractAll(destination);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public boolean startUpdateConfirmation() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int selection1;
                Splash.this.updateSelection = selection1 = JOptionPane.showConfirmDialog(null, "An update is available. Do you wish to download?", "Update Available", 2, 1);
            }
        });
        return true;
    }

    public static boolean startHDSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int selection1;
                hdSelection = selection1 = JOptionPane.showConfirmDialog(null, "Would you like to launch with Java 1.6? This is only necessary if you wish to play on High-definition!", "Use Java 1.6? (Required for HD on Macs)", 0, 1);
            }
        });
        return true;
    }

    public static void unlockButtons() throws InterruptedException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                pbar.setString("Ready to launch. Select the client you wish to play above.");
                playVanillaButton.setEnabled(true);
                playRuneliteButton.setEnabled(true);
            }
        });
    }

    public static void startApplication(String fileToLaunch) throws InterruptedException {
        double version = Splash.getJavaVersion();
        System.out.println("Java version on runtime: " + version + ".");
        String executionPath = Splash.getJavaExecutionPath();
        if (executionPath.contains(" ")) {
            executionPath = "\"" + executionPath + "\"";
        }
        System.out.println("Java Path: " + executionPath);
        if ((executionPath.contains("jdk-10") || executionPath.contains("jdk-11") || executionPath.contains("jdk-12") || executionPath.contains("jdk-13") || executionPath.contains("jdk-14") || executionPath.contains("jdk-15") || executionPath.contains("jdk-16") || executionPath.contains("jdk-17") || executionPath.contains("jdk-18") || executionPath.contains("jdk-19") || executionPath.contains("jdk-20")) && Splash.isMac()) {
            System.out.println("JDK-10 or higher on Mac. Launching with 'java -jar' command.");
            executionPath = "java";
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(executionPath);
        System.out.println("Manually disabling Hardware Acceleration. Added -Dsun.java2d.noddraw=true and -Dsun.java2d.opengl=false");
        params.add("-Dsun.java2d.noddraw=true");
        params.add("-Dsun.java2d.opengl=false");
        params.add("-jar");
        params.add(saveDirectory + fileToLaunch);
        if (arguments != null && arguments.length > 0) {
            for (String arg : arguments) {
                if (arg == null || arg.toLowerCase().contains("hw_acceleration")) continue;
                params.add(arg);
                System.out.println("Adding arg: " + arg);
            }
        }
        System.out.println("Parameters: " + params.toString());
        ProcessBuilder bldr = new ProcessBuilder(params);
        try {
            bldr.start();
            Thread.sleep(1000L);
            System.exit(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static double getJavaVersion() {
        String version = System.getProperty("java.version");
        System.out.print(version);
        if (version.contains(".")) {
            int pos = version.indexOf(46);
            pos = version.indexOf(46, pos + 1);
            return Double.parseDouble(version.substring(0, pos));
        }
        return Double.parseDouble(version);
    }

    private static String getJavaExecutionPath() {
        String close = System.getProperty("java.home");
        if (close != null) {
            File localFile1 = new File(close = close + "/bin/");
            if (!localFile1.exists()) {
                close = null;
            } else {
                File[] arrayOfFile1 = localFile1.listFiles();
                if (arrayOfFile1 != null) {
                    for (File localFile2 : arrayOfFile1) {
                        if (localFile2 == null || !Splash.parameterContains(localFile2.getName())) continue;
                        close = close + localFile2.getName();
                        break;
                    }
                } else {
                    close = null;
                }
            }
        }
        close = close == null || close.contains(".plugin") ? "java" : close.replace("\\", "/");
        return close;
    }

    private static boolean parameterContains(String paramString) {
        return paramString.equals("java") || paramString.equals("java.exe") || paramString.equals("java.sh") || paramString.equals("java.bat");
    }

    public static void applyQualityRenderingHints(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return Splash.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        BufferedImage image = Splash.getGraphicsConfiguration().createCompatibleImage(width, height, transparency);
        image.coerceData(true);
        return image;
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return Splash.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return Splash.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static BufferedImage generateBlur(BufferedImage imgSource, int size, Color color, float alpha) {
        GaussianFilter filter = new GaussianFilter(size);
        int imgWidth = imgSource.getWidth();
        int imgHeight = imgSource.getHeight();
        BufferedImage imgBlur = Splash.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgBlur.createGraphics();
        Splash.applyQualityRenderingHints(g2);
        g2.drawImage((Image)imgSource, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(5, alpha));
        g2.setColor(color);
        g2.fillRect(0, 0, imgSource.getWidth(), imgSource.getHeight());
        g2.dispose();
        imgBlur = filter.filter(imgBlur, null);
        return imgBlur;
    }

    public static BufferedImage generateShadow(BufferedImage imgSource, int size, Color color, float alpha) {
        int imgWidth = imgSource.getWidth() + size * 2;
        int imgHeight = imgSource.getHeight() + size * 2;
        BufferedImage imgMask = Splash.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgMask.createGraphics();
        Splash.applyQualityRenderingHints(g2);
        int x = Math.round((float)(imgWidth - imgSource.getWidth()) / 2.0f);
        int y = Math.round((float)(imgHeight - imgSource.getHeight()) / 2.0f);
        g2.drawImage((Image)imgSource, x, y, null);
        g2.dispose();
        BufferedImage imgGlow = Splash.generateBlur(imgMask, size * 2, color, alpha);
        return imgGlow;
    }

    public static String readStringFromURL(String requestURL) throws IOException {
        String line2;
        String[] commands = new String[]{"curl", "-X", "GET", requestURL};
        Process process = Runtime.getRuntime().exec(commands);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String response = "";
        while ((line2 = reader.readLine()) != null) {
            response = response + line2;
        }
        if (response.length() > 4 || !Splash.isNumeric(response)) {
            System.out.println("Failed to get playercount. Non-numeric curl response: " + response);
            return "";
        }
        return response;
    }

    public static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    static {
        downloadedLatestClient = false;
        hdSelection = -1;
        isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        forceLatestJava = false;
    }

    public static class FrameDragListener
    extends MouseAdapter {
        private final JFrame frame;
        private Point mouseDownCompCoords = null;

        public FrameDragListener(JFrame frame) {
            this.frame = frame;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDownCompCoords = null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseDownCompCoords = e.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point currCoords = e.getLocationOnScreen();
            this.frame.setLocation(currCoords.x - this.mouseDownCompCoords.x, currCoords.y - this.mouseDownCompCoords.y);
        }
    }

    static class DefaultTrustManager
    implements X509TrustManager {
        DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public class ShadowPane
    extends JPanel {
        private BufferedImage shadow;

        public ShadowPane() {
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
        }

        @Override
        public void invalidate() {
            this.shadow = null;
            super.invalidate();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = this.getWidth() - (insets.left + insets.right);
            int height = this.getHeight() - (insets.top + insets.bottom);
            if (this.shadow == null) {
                int shadowWidth = Math.min(Math.min(insets.left, insets.top), Math.min(insets.right, insets.bottom));
                this.shadow = new BufferedImage(width, height, 2);
                Graphics2D g2d = this.shadow.createGraphics();
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, width, height);
                g2d.dispose();
                this.shadow = Splash.generateShadow(this.shadow, shadowWidth, Color.BLACK, 0.8f);
            }
            g.drawImage(this.shadow, 0, 0, this);
            g.setColor(this.getBackground());
            g.fillRect(x, y, width, height);
        }
    }
}

